\version "2.22.2"

\header {
  texidoc = "
Scripts may be defined as stencil expressions, by defining their
@code{stencil} property.

"
  doctitle = "Adding or modifying Script articulations"
}
#(define long-espr-stil
   (lambda (grob)
     (ly:stencil-scale
      (ly:font-get-glyph
       (ly:grob-default-font grob)
       "scripts.espr")
      2 1)))

%% Thanks to Andrew Bernard:
% https://lists.gnu.org/archive/html/lilypond-user/2019-02/msg00440.html
#(define upbow-stil
   (make-path-stencil
    '(
       moveto 0 1.3
       lineto 0.25 1.3
       lineto 0.57 0.46
       lineto 0.9 1.3
       lineto 1 1.3
       lineto 0.5 0
       lineto 0 1.3
       closepath)
    .01 1 1 #t))

%% Since 2.23.6 articulation types should be symbols instead of strings.
%% I.e. change "longEspressivo" to 'longEspressivo and "upbow" to 'upbow
%%   --Harm

#(define new-script-alist
   (append default-script-alist
     (list
      `(longEspressivo
         . (
             (stencil . ,long-espr-stil)
             (toward-stem-shift-in-column . 0.0)
             (padding . 1)
             (avoid-slur . around)
             (direction . ,UP)))
      )))


#(assoc-set! new-script-alist 'upbow
   (acons
    'stencil upbow-stil
    (assoc-ref new-script-alist 'upbow)))

\layout {
  \context {
    \Score
    scriptDefinitions = #new-script-alist
  }
}

longEspr = #(make-articulation 'longEspressivo)

{ b1\longEspr b\upbow}


