\version "2.22.2"

\header {
  texidoc = "
Starting bars usually are all clones of the first one.  The only way to
affect one system and not the others is to collect all the grobs using
the @code{all-elements} property of any grob on the system in question
(for example a @code{NoteHead}) and filter the target grob, which you
can then modify.




"
  doctitle = "Modify only the current system"
}
%% Thanks to David Nalesnik:
%% https://lists.gnu.org/archive/html/lilypond-user/2019-03/msg00205.html

#(define drop-in-on-spanner
   (lambda (grob)
     (let* ((elts (ly:grob-array->list (ly:grob-object (ly:grob-system grob) 'all-elements)))
            (ssb (filter (lambda (e) (grob::has-interface e 'system-start-delimiter-interface))
                         elts)))
       (set! (ly:grob-property (car ssb) 'color) red))))

\new StaffGroup <<
  \new Staff {
    c'1 \break
    \tweak after-line-breaking #drop-in-on-spanner
    c' \break
    c' \break
  }
  \new Staff {
    c' c' c'
  }
>>

\paper { tagline = ##f }


