\version "2.22.2"

\header {
  texidoc = "
To change the size of an individual staff, you would @code{\\set} the
@code{fontSize} property of the @code{Staff} context, and
@code{\\override} the @code{'staff-space}, and @code{'thickness}
properties of the @code{StaffSymbol}.


This snippet shows how to simplify this process by defining a music
function called @code{staffSize}.  It works as a macro and sets each of
these three properties for you.  (It can actually be used in any
context that has a font size engraver, not just @code{Staff} contexts.)


If you want to resize all the staves in the file (and all the text as
well), a simpler way is to use @code{#(set-global-staff-size xx)}. 

"
  doctitle = "Changing the size of a staff with a music function"
}
%%http://lsr.di.unimi.it/LSR/Item?id=862

staffSize = #(define-music-function (new-size) (number?)
  #{
    \set fontSize = #new-size
    \override StaffSymbol.staff-space = #(magstep new-size)
    \override StaffSymbol.thickness = #(magstep new-size)
  #})

theMusic = \relative c' { 
  a'8 a a a a \ff a a a
}

\score {
  <<
    \new Staff 
      { \theMusic }

    \new Staff \with {
      fontSize = #-3
      \override StaffSymbol.staff-space = #(magstep -3)
      \override StaffSymbol.thickness = #(magstep -3)
      } 
      { \theMusic }

    \new Staff 
    \with { \staffSize #-3 } 
      { \theMusic }
  >>
}



