\version "2.22.2"

\header {
  texidoc = "
Punctuation can be added to the end of an extender in melismata by
overriding the default stencil for @code{LyricExtender}. For
convenience, this snippet applies the stencil override as a tweak to
the extender event. 

"
  doctitle = "Adding punctuation to the end of an extender in melismata"
}
%% http://lsr.di.unimi.it/LSR/Item?id=643

%LSR contributed by Neil Puttock

#(define (extend text . padding)
   (let ((extender (make-music 'ExtenderEvent))
	 ;; optional padding
	 (padding (if (pair? padding)
		      (car padding)
		      0)))
     #{ 
       \tweak 
         stencil
         #(lambda (grob)
           (let* ((orig (ly:grob-original grob))
                  (siblings (ly:spanner-broken-into orig)))
           
             (if (or (null? siblings)
                 (and (>= (length siblings) 2)
                      (eq? (car (last-pair siblings)) grob)))
             (ly:stencil-combine-at-edge
               (ly:lyric-extender::print grob)
               X RIGHT
               (grob-interpret-markup grob text)
               padding))))
         $extender
     #}))

%Define custom extenders, first with extra padding
extendComma = #(extend "," 0.2)
extendExclaim = #(extend "!")

\score {  
  <<
    \new Staff \new Voice = melody \relative c' {
      c4( d e f)
      g4( f e2)
    }
    \new Lyrics \lyricsto melody {
      Aah \extendComma
      Ooh \extendExclaim
    }
  >>
  \layout {
    \context {
      \Lyrics
      \consists "Tweak_engraver"
    }
  }
}



