\version "2.22.2"

\header {
  texidoc = "
Git is a distributed version-control system. Lilypond itself is
developed using Git. It's useful to keep your .ly files in a Git
repository: it ensures you can get back old versions of your files if
you take a piece in the wrong direction, it makes it easy to share your
work with others and incorporate each other's changes, and it lets you
look back to see when you made particular changes. But if you're
printing out your Lilypond parts, it's easy to get confused about which
is the latest version, or what source a print-out was generated from.


The usual workaround is to use the date, but this only tells you when
the PDF was generated, not when the source was written. This snippet is
some trivial Scheme code that declares a @code{\\commit} variable
containing the current HEAD of the Git repository. (It's simple to
change it to show the hash of the file, or the date of the HEAD commit,
or the revision number from Subversion, CVS, or whatever else you use.
It just runs a command and expects the output to be one line.)


Please ignore the displayed output of the snippet. It's there because
all snippets need to produce output. The interesting stuff is in the
file itself. 

"
  doctitle = "Showing git commit hash (or other revision number)"
}
%% http://lsr.di.unimi.it/LSR/Item?id=567

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This is the code. Paste it into a file you can \include. It's commented out
% because it won't run in the LSR's sandbox.

%{
#(use-modules (ice-9 popen))
#(use-modules (ice-9 rdelim))
commit =
#(let* ((port (open-pipe* OPEN_READ "git" "show" "--pretty=format:%H" "--quiet"))
        (str  (read-line port)))
   (close-pipe port)
   str)
%}

% and I use that command like this:
%\header {
%  tagline = \commit
%}

% This is just to give LSR something to compile. It doesn't like empty files.

{ c''4 c'' c'' c'' }



