\version "2.22.2"

\header {
  texidoc = "
In modern editions of early music, it is common to typeset implicit
lyrics (marked with \"ij\") in italics; this snippet demonstrates a way
to handle cases where italic and plain lyric text fall on the same
syllable, and a lyric tie (~) is desired.

"
  doctitle = "Adding markup to part of a syllable connected with lyric ties (~)"
}
% Adding<D-`> markup to part of a syllable connected with lyric ties (~)

\layout {
  \context {
    \Score
    % Increase spacing to make hyphens apparent
    \override SpacingSpanner.common-shortest-duration = #(ly:make-moment 1/64)
  }
}

%----------

text_i = \lyricmode {
  % Markup for the start of the first sentence
  \override Lyrics.LyricText.font-shape = #'italic
  in -- chi -- nar --
  \revert Lyrics.LyricText.font-shape

  % First half of tied syllable marked up
  \markup \concat { \italic "vi" \tied-lyric "~in" }

  % Plain second sentence
  ter -- ra
}

text_ii = \lyricmode {
  % Plain start of the first sentence
  in ter --

  % Second half of tied syllable marked up
  \markup \concat { \tied-lyric "ra~" \italic "in" }

  % Markup for the rest of the second sentence
  \override Lyrics.LyricText.font-shape = #'italic
  ter -- ra
  \revert Lyrics.LyricText.font-shape
}

% More complicated examples
text_iii = \lyricmode {
  \markup \concat { \with-color #red "a" \tied-lyric "~e~i" }
  \markup \concat { \tied-lyric "a~" \with-color #red "e" \tied-lyric "~i" }
  \markup \concat { \tied-lyric "a~e~" \with-color #red "i" }
}

\score {
  <<
    \new Voice = "V1" \relative c'' {
      c4 4 b4 4 2 a
    }
    \new Lyrics \lyricsto "V1" \text_i

    \new Voice = "V2" \relative c'' {
      r4 c4 b4 4 2 a
    }
    \new Lyrics \lyricsto "V2" \text_ii

    \new Voice = "V3" \relative c'' {
      c4 b a r
    }
    \new Lyrics \lyricsto "V3" \text_iii
  >>
}

\paper { tagline = ##f }

