\version "2.22.2"

\header {
  texidoc = "
This snippet supports svg output.

"
  doctitle = "Orchestral grouping with a custom brace"
}
%% http://lsr.di.unimi.it/LSR/Item?id=986

% Credits: Kieren MacMillan and P.P.Schneider.
% => http://lists.gnu.org/archive/html/lilypond-user/2013-03/msg00260.html
% see also: http://lsr.di.unimi.it/LSR/Item?id=988

%here starts the snippet:

%%% Defining a custom strait brace with a variable length:
#(define-markup-command (long-curly-bracket layout props arg-height)(number?)
  "Draw a curly bracket with a variable length."
     (interpret-markup layout props
       (markup
        #:translate (cons 0 (* (+ arg-height 5.5) -1))
        (#:with-dimensions (cons -0.001 0) (cons 0.001 0)
         (#:override (cons (quote filled) #t)
          (#:path 0.01 `(
           (moveto   -0.8   0.0)
           (curveto  -0.2   0.4  -0.3  0.7 -0.3  1.5)
           (lineto   -0.3   ,arg-height)
           (curveto  -0.4   ,(+ arg-height 1.3) 0.5 ,(+ arg-height 2.8) 0.7 ,(+ arg-height 2.8))
           (curveto   0.6   ,(+ arg-height 2.5) 0.1 ,(+ arg-height 2)   0.1 ,arg-height)
           (lineto    0.1   1.5)
           (curveto   0.1   0.7   0.1   0.0  -0.8   0.0)
           (closepath)
           (curveto  -0.2  -0.4  -0.3  -0.7  -0.3  -1.5)
           (lineto   -0.3   ,(* arg-height -1))
           (curveto  -0.4   ,(* (+ arg-height 1.3) -1) 0.5 ,(* (+ arg-height 2.8) -1) 0.7 ,(* (+ arg-height 2.8) -1))
           (curveto   0.6   ,(* (+ arg-height 2.5) -1) 0.1 ,(* (+ arg-height 2) -1)   0.1 ,(* arg-height -1))
           (lineto    0.1  -1.5)
           (curveto   0.1  -0.7   0.1   0.0  -0.8   0.0)
           (closepath))))))))

%%%%% Example:
someMusic = { 
  \tempo "Andante."  
  \time 3/4
  \key c \minor
  c'2. r8 
}

\paper {
  indent = 40
  tagline = ##f
}

\layout {
  \context {
    \Staff
    \override InstrumentName.font-size = #-1
  }
  \context {
    \StaffGroup
    \name ViolinGroup
    \alias StaffGroup
    systemStartDelimiter = #'SystemStartBrace
  }
  \context {
    \StaffGroup
    \name WindGroup
    \alias StaffGroup
    systemStartDelimiter = #'SystemStartBracket
    \override SystemStartBracket.collapse-height = #1
  }
  \context {
    \StaffGroup
    \name StringGroup
    \alias StaffGroup
    \accepts ViolinGroup
    systemStartDelimiter = #'SystemStartBracket
  }
  \context {
    \StaffGroup
    \name OrchestraGroup
    \accepts WindGroup
    \accepts StringGroup
    systemStartDelimiter = #'SystemStartSquare
    \override SystemStartSquare.X-offset = #-15
    \override SystemStartSquare.stencil = 
      #(lambda (grob) (grob-interpret-markup grob 
                        #{
                          \markup { \long-curly-bracket #13.5 }
                        #}))
    instrumentName = \markup { \rotate #90 "Orchestra I" }
    \override InstrumentName.extra-offset = #'(9.5 . 0)
  }
  \context {
    \GrandStaff
    \remove "System_start_delimiter_engraver"
    \accepts OrchestraGroup
    \accepts StaffGroup
  }
}

\score {
  \new GrandStaff <<
    \new OrchestraGroup <<
      \new WindGroup <<
        \new Staff \with { 
          instrumentName = "Oboe" 
          \override InstrumentName.padding = #-12
        } \someMusic
      >>
      \new StringGroup <<
        \new ViolinGroup <<
          \new Staff \with { 
            instrumentName = "Violino I" 
            \override InstrumentName.padding = #-9
          } \someMusic
          \new Staff \with { 
            instrumentName = "Violino II" 
            \override InstrumentName.padding = #-9
          } \someMusic
        >>
        \new Staff \with { 
            instrumentName = "Viola" 
            \override InstrumentName.padding = #-12
          } { \clef C \someMusic }
      >>
    >>
    \new StaffGroup <<
      \new Staff \with { 
      	instrumentName = "Soprano" 
      	\override InstrumentName.padding = #-20.5
      } \someMusic
      \new Staff \with { 
      	instrumentName = "Alto" 
      	\override InstrumentName.padding = #-22.5
      } { \clef C \someMusic }
    >>
  >>
}


