\version "2.22.2"

\header {
  texidoc = "
This code shows how to transpose a whole score by changing one single
piece of code.


In the code the Scheme function @code{MyTranspose} is defined. If you
use it in every @code{Voice}, you can transpose the whole score just by
setting the arguments to the @code{\\transpose} call within the
function definition. As you see in the example this works with
transposed voices as well (in the example I've written the Bb-Trumpet
pitches as they sound, so they have to be additionaly transposed by
@code{\\transpose bes c' @{...@}}).


To see the original pitches, you may disable the @code{MyTranspose}
function by redefining @code{MyTranspose = @{@}}, as shown in the lower
part of the snippet.



"
  doctitle = "Flexible Transposing a whole score"
}
%% http://lsr.di.unimi.it/LSR/Item?id=787

%here starts the snippet:

global = {
  \time 4/4
}

MyTranspose = 
#(define-music-function (m)
  (ly:music?)
  #{ \transpose f d $m #})
% In the previous line the transposition of the whole score is defined
% (in this case from f major down to d major).
\markup "Transposed from F to D"

% To deactivate the transposition remove the comment sign from the
% following line:
%MyTranspose = {}

Basekey = {
  \key f \major
}

FltPitches = \relative c'' { c d bes c }
TrpPitches = \relative c'' { c d bes c }

Flt = \new Voice {
  \set Staff.instrumentName = #"Flute" 
  \MyTranspose { \Basekey \FltPitches }
}
Trp = \new Voice \transpose bes c' { 
  \set Staff.instrumentName = #"Trumpet" 
  \MyTranspose { \Basekey \TrpPitches }
}
\score {
  \new StaffGroup {
    << 
      \new Staff { << \global \Flt >> }
      \new Staff { << \global \Trp >> }
    >> }
  \layout {}
}

% End of the example
% =============================================================
% The remainder is just for visualisation the deactivation of the
% transposition in a single snippet. You don't need this code in
% normal use...

\markup "The same without transposition:"
MyTranspose = {}

% The remainder is just a copy of the corresponding lines above:
Flt = \new Voice {
  \set Staff.instrumentName = #"Flute" 
  \MyTranspose { \Basekey \FltPitches }
}

Trp = \new Voice \transpose bes c' { 
  \set Staff.instrumentName = #"Trumpet" 
  \MyTranspose { \Basekey \TrpPitches }
}

\new StaffGroup <<
  \new Staff << \global \Flt >>
  \new Staff << \global \Trp >>
>>

\paper { tagline = ##f }

