\version "2.22.2"

\header {
  texidoc = "
To insert alternative eyeglasses into a score (strongly indicating that
one should look at the conductor), one has to insert self-defined path
code as a markup. myEyeglasses support svg ouput. 

"
  doctitle = "Eyeglasses as markup (path)"
}
%% http://lsr.di.unimi.it/LSR/Item?id=982
%% see also http://lsr.di.unimi.it/LSR/Item?id=435

% Credit: PPS on March 2015

\paper { tagline = ##f }

#(define my-eyeglassespath
  '((moveto   -3.57   1.80)
     (curveto  -3.65   1.90  -3.55   2.22  -3.33   2.22)
     (curveto  -3.17   2.22  -3.15   2.15  -3.10   2.10)
     (lineto   -2.02   0.94)
     (moveto   -2.06   0.65)
     (curveto  -2.06   1.00  -1.75   1.28  -1.45   1.28)
     (curveto  -1.10   1.28  -1.07   1.05  -1.07   0.90)
     (curveto  -1.07   0.62  -1.30   0.27  -1.70   0.27)
     (curveto  -1.85   0.25  -2.06   0.40  -2.06   0.65)
     (closepath)
     (moveto   -1.14   1.20)
     (curveto  -1.00   1.44  -0.72   1.52  -0.57   1.35)
     (moveto   -0.61   1.05)
     (curveto  -0.61   1.42  -0.30   1.68   0.00   1.68)
     (curveto   0.22   1.68   0.37   1.52   0.37   1.28)
     (curveto   0.37   0.96   0.06   0.65  -0.25   0.64)
     (curveto  -0.30   0.64  -0.61   0.65  -0.61   1.05)
     (closepath)
     (moveto    0.12   1.68)
     (lineto   -1.10   2.69)
     (curveto  -1.50   3.05  -1.80   2.75  -1.71   2.45)))

#(define-markup-command (myEyeglasses layout props)
  ()
 "Prints out alternative eyeglasses, indicating strongly to look at the conductor."
  (interpret-markup layout props
    #{
       \markup
       \override #'(line-cap-style . butt)
       \path #0.15
       \my-eyeglassespath
    #}))

%%%% Example:

\markup\italic "Standard eyeglasses" 
%% as defined in define-markup-commands.scm
\relative c'' { 
  c2^\markup\eyeglasses  
  a2_\markup\eyeglasses 
}

\markup\italic "Alternative eyeglasses"
\relative c'' { 
  c2^\markup\myEyeglasses  
  a2_\markup\myEyeglasses 
}



