\version "2.22.2"

\header {
  texidoc = "
When dealing with live electronics notation, it's common to use circled
numbers (with or without a description of the electronic effect) at the
cue places. This type of notation is particularly common in pieces in
which the instrumentalist uses a MIDI footpedal to activate events,
though might be used in a wider context.

"
  doctitle = "Circled numbers for live electronics"
}
LEtext = #(define-event-function 
     (N vlength description)
     (number? number? string?)
      #{
        -\markup { 
          \hspace #-1.2
          \center-column {                
            \raise #1
            \combine            
            \arrow-head #Y #UP ##t
            \draw-line #(cons 0 (- vlength))
            \combine
            \halign #0 \circle \transparent "888"
            \halign #0 #(number->string N)
          }
          \raise #(+ -2 (- vlength)) $description
        }        
      #})
       
LE = #(define-event-function (N vlength)(number? number?)
     #{ \LEtext $N $vlength "" #})

{  
  \textLengthOn
  c'1\LE #1 #3
  g1\LE #2 #1.5
  c''1\LE #37 #4.4
  f'1\LE #123 #2
  c'1\LEtext #3 #8 "harmonizer"
  f1\LEtext #20 #6 "frozen reverb"
  c'1\LEtext #300 #3 "EQ -3.7 A +1.2"
}


