\version "2.22.2"

\header {
  texidoc = "
In a TabStaff, the tuning of each string can be displayed to the left
of the system using markup commands.

"
  doctitle = "Name tuning of each string in a TabStaff"
}
%% http://lsr.di.unimi.it/LSR/Item?id=658


%% Currently there's a bug in LSR
%% Thus the overrides for font-name below are commented
%% See: https://lists.gnu.org/archive/html/lilypond-user/2025-07/msg00073.html
%% --Harm, July 2025

%%------------------------------------------

\layout {
  tagline = ##f
}

\layout {
  \override Staff.InstrumentName.self-alignment-X = #RIGHT
}

EADGBE =
\markup {
  \fontsize #-4
  \override #'(baseline-skip . 1.5)
  \column 
    %\override #'(font-name . "Arial Bold") 
    {
      E B G D A E
    }
}
%%------------------------------------------------
\new TabStaff {
  \set TabStaff.instrumentName = \markup { " " \EADGBE }
  \set TabStaff.shortInstrumentName = \markup \EADGBE
  e,8 c e gis b e'
}

%% To get accidentals from the musicfont use
%% \concat { <string-name> \musicglyph <accidental-string> }
%% use \raise and \fontsize to taste
strangeTuning =
\markup {
  \fontsize #-4
  \override #'(baseline-skip . 1.5)
  \column 
    %\override #'(font-name . "Arial Bold") 
    {
      D C
      \concat {
        F
        \raise #0.5 \fontsize #-2  \musicglyph #"accidentals.sharp"
      }
      D
      \concat {
        B
        \raise #0.2 \fontsize #-2 \musicglyph #"accidentals.flat"
      }
      F
    }
}

<<
\new Staff { \clef "G_8" f, bes, d fis c' d' }
\new TabStaff {
  \set TabStaff.stringTunings = \stringTuning <f, bes, d fis c' d'> %D C F D Bb F>
  \set TabStaff.instrumentName = \markup { " " \strangeTuning }
  \set TabStaff.shortInstrumentName = \markup \strangeTuning
  f, bes, d fis c' d'
}
>>

%%------------------------------------------------

