\version "2.22.2"

\header {
  texidoc = "
This example shows a trick to insert a vertical brace when going from
several stanzas into a common ending in the lyrics. (An alternative is
of course to just skip the brace, especially if you add a line break
instead).

"
  doctitle = "Vertical brace spanning several lyrics lines"
}
%% http://lsr.di.unimi.it/LSR/Item?id=265

% The argument to \left-brace and \right-brace is the point-size of the bracket
%
% translate is needed to simulate alignment not to the baseline of the text, but
% to the vertical center

leftbrace = \set stanza = \markup {
  \hspace #1
  \translate #'(0 . 0.8) \left-brace #45 }

rightbrace = \set stanza = \markup {
  \hspace #1
  \translate #'(0 . 0.8) \right-brace #45 }

lyricsbeforebrace = \lyricmode { Here are some ly -- rics }

lyricsfrombrace = \lyricmode { Here come some more }

melody = \relative c' { c d e f g f e d c }

\score{
  <<
    \new Voice = m \melody
    \new Lyrics \lyricsto m \lyricsbeforebrace
    \new Lyrics \lyricsto m { \lyricsbeforebrace \rightbrace \lyricsfrombrace }
    \new Lyrics \lyricsto m \lyricsbeforebrace
  >>
}

%{
%% Below a version for even number of Lyric-contexts
%% see: 
%% http://lists.gnu.org/archive/html/lilypond-user/2016-01/msg00120.html

dropLyrics = {
  \override LyricText.extra-offset = #'(0 . -1)
  \override LyricHyphen.extra-offset = #'(0 . -1)
  \override LyricExtender.extra-offset = #'(0 . -1)
  \override StanzaNumber.extra-offset = #'(0 . -1)
}

leftbrace = \set stanza = \markup {
  \hspace #1
  \translate #'(0 . -0.6) \left-brace #25 }

rightbrace = \set stanza = \markup {
  \hspace #1
  \translate #'(0 . 0.4) \right-brace #25 }

lyricsbeforebrace = \lyricmode { Here are some ly -- rics }

lyricsfrombrace = \lyricmode { Here come some more }

melody = \relative c' { c d e f  g f e d c }

\score{
  <<
    \new Voice = m { \autoBeamOff \melody } 
    \new Lyrics \lyricsto m  {
      \leftbrace \lyricsbeforebrace \rightbrace  \dropLyrics \lyricsfrombrace
    }
    \new Lyrics \lyricsto m { \lyricsbeforebrace  }
  >>
}
%}


