\version "2.22.2"

\header {
  texidoc = "
Traditionally, smaller staves key signature spacing is slightly
different than full size staves ones.

Here's a function that automatically calculates the right key signature
spacing according to the staff size. 

"
  doctitle = "Key signature and small staff"
}
%% => http://lsr.di.unimi.it/LSR/Item?id=1094

%% This extends \staffSize as defined in 
%% "Changing the size of a staff with a music function"
%% http://lsr.di.unimi.it/LSR/Item?id=862
staffSize = #(define-music-function (new-size) (number?)
  #{
    \set fontSize = #new-size
    \override StaffSymbol.staff-space = #(magstep new-size)
    \override StaffSymbol.thickness = #(magstep new-size)
    \override KeySignature.padding = #(* 2/3 (- 1 (magstep new-size)))
  #})

keyTest = { \key cis\major s4*4 \bar "" }

\markup\italic "Default output:"
<<
  \new Staff \with { 
    fontSize = #-3
    \override StaffSymbol.staff-space = #(magstep -3)
    \override StaffSymbol.thickness = #(magstep -3)
  } \keyTest 
  \new Staff \keyTest 
  
>>

\markup\italic "Traditional output:"
<<
  \new Staff \with { \staffSize #-3 } \keyTest 
  \new Staff \keyTest 
  
>>

%{
% For v.2.19 and higher:

scaleStaff = #(define-music-function (scaleFac) (number?)
                 #{
                   \magnifyStaff #scaleFac
                   \override KeySignature.padding = #(* 2/3 (- 1 scaleFac))
                 #})

sizeTest = #5/7
keyTest = { \key cis\major s4*4 \bar "" }

<<
  \new Staff \with { \scaleStaff #sizeTest } \keyTest
  \new Staff \keyTest
>>
 %}

\paper { tagline = ##f }

