\version "2.22.2"

\header {
  texidoc = "
A music-function uses variables at the point where it's invoked; as a
result, if variables are then redefined, the same function will then
use the same variables with their new value.

This makes it possible to generate scores in a semi-automated way, as
demonstrated here.

"
  doctitle = "Generating scores within a function"
}
%% LSR originally contributed by Gilles Thibault:
%% https://lists.gnu.org/archive/html/lilypond-user-fr/2011-11/msg00141.html
%% See also http://lsr.di.unimi.it/LSR/Item?id=630
%% and https://lists.gnu.org/archive/html/lilypond-user/2015-04/msg00311.html

\paper { tagline = ##f }

duo =
#(define-music-function (nr) (number?)
   (let* ((s (number->string nr))
          (h (make-module))
          (m (ly:make-score
              #{<<
                \new Staff { \global \clarI }
                \new Staff { \global \clarII }
                >>
              #})))
     (module-define! h 'piece (markup #:concat ("Duo n." s)))
     (ly:score-set-header! m h)
     (collect-scores-for-book m)
     (make-music 'Music 'void #t)))

%%%%%%%%%% Duo 1
global = { \key c \major \time 4/4 }
clarI = { e'1}
clarII = { c'1}
\duo #1

%%%%%%%%%% Duo 2
global = { \key d \minor \time 3/4 }
clarI = { f'2.}
clarII = { d'2.}
\duo #2

%%%%%%%%%% Duo 3
global = { \key e \minor \time 2/4 }
clarI = { g'2}
clarII = { e'2}
\duo #3



