\version "2.22.2"

\header {
  texidoc = "
When you have multiple overflowing measures, the music flows off the
page. This snippet forces an error when this happens by checking the
width of each system and checking it against the paper width.

"
  doctitle = "Compilation error on music overflow"
}
scorepaper = \paper { }

#(define staffcount 0)

\relative c' {
  \override Staff.StaffSymbol.after-line-breaking =
    #(lambda (grob)
       (set! staffcount (+ staffcount 1))
       (let* ((staff-width (interval-length (ly:grob-property grob 'X-extent)))
              (staff-space (ly:output-def-lookup scorepaper 'staff-space))
              (paper-width (ly:output-def-lookup scorepaper 'paper-width))
              (my-width (/ paper-width staff-space)))
         (if (> staff-width my-width)
             (ly:error "Music overflows page at staff ~a." staffcount))))
  %% uncomment this and compilation will fail, throwing a music overflow error.
  %r4 
  \repeat unfold 100 { c1 }
}


