\version "2.22.2"

\header {
  texidoc = "
In polymetric music, a composer may indicate beat structure by
following one time signature with another in parenthesis, for example:
3/4 (6/8) indicating a 6/8 beat in a 3/4 measure, or 6/4 (6/8)
indicating a 6/8 beat in a 6/4 measure. This snippet is derived from
the parenthesize-time snippet, adding an unparenthesized fraction in
front of the parenthesized one.

"
  doctitle = "Time signature with alternate in parentheses"
}
%% http://lsr.di.unimi.it/LSR/Item?id=782

#(define ((time-parenthesized-time up down upp downp) grob)
   (grob-interpret-markup grob
     (markup #:override '(baseline-skip . 0) #:number
       (#:line (
           (#:center-column (up down))
           #:vcenter "("
           (#:center-column (upp downp))
           #:vcenter ")" )))))

\relative c' {
   \override Staff.TimeSignature.stencil = #(time-parenthesized-time "3" "4" "6" "8")      
   \time 3/4
   b8 b8 gis8 gis4 gis8
}



