\version "2.22.2"

\header {
  texidoc = "
This snippet demonstrates how to add angle-wings to the BarLines of an
entire StaffGroup.


It is done manually by applying the here-defined function
@code{repeatBarGroupAlter} at appropriate locations.


@code{repeatBarGroupAlter} needs three arguments:
@code{repeat-bar-type}, @code{repeat-bar-height}, and
@code{repeat-bar-translate}. 

"
  doctitle = "Repeat-bar-lines with angle-wings for whole StaffGroup (manually)"
}
%% http://lsr.di.unimi.it/LSR/Item?id=991
% <= http://lilypond.1069038.n5.nabble.com/Applying-alternate-quot-bar-style-quot-to-whole-StaffGroup-td160401.html
%% see also: http://lsr.di.unimi.it/LSR/Item?id=989
%% Credits: PPS on April 2015

%here starts the snippet:

\markup\italic "Standard alternate repeat barline output in a StaffGroup:"
\new StaffGroup <<
  \new Staff \relative c' {
    \set Score.startRepeatBarType = #"[|:"
    \set Score.endRepeatBarType = #":|]"
    c4 d e f
    \repeat volta 2 { 
      g a b c
      d e f g
    }
    s8
  }
  \new Staff \relative c {
    \clef F
    c4 d e f
    \repeat volta 2 { 
      g a b c
      d e f g
    }
    s8
  }
  \new Staff \relative c, {
    \clef F
    c4 d e f
    \repeat volta 2 { 
      g a b c
      d e f g
    }
    s8
  }
>>

\markup\italic "Workaround to get a new alternate repeat barline output:"

#(define-markup-command (staff-group-bracket layout props bracket-height)(number?)
  "Draw a bracket with a variable length."
     (interpret-markup layout props
       (markup
        (#:with-dimensions (cons -0.001 0) (cons 0.001 0)
         (#:override (cons (quote filled) #t)
          (#:path 0.01 `(
           (moveto  0.00  ,(+ bracket-height 0.35))              
           (curveto  0.00  ,(+ bracket-height 0.43)  0.07 ,(+ bracket-height 0.42)  0.10 ,(+ bracket-height 0.42))
           (curveto  0.70  ,(+ bracket-height 0.42)  1.10 ,(+ bracket-height 0.60)  1.76 ,(+ bracket-height 1.50))
           (curveto  1.82  ,(+ bracket-height 1.58)  1.89 ,(+ bracket-height 1.50)  1.85 ,(+ bracket-height 1.45))
           (curveto  1.14  ,(+ bracket-height 0.40)  0.93 ,(+ bracket-height 0.18)  0.45 ,bracket-height) 
           (lineto   0.00  ,bracket-height)
           (closepath)
           (moveto   0.00  ,(* bracket-height -1))
           (curveto  0.00  ,(+ (* bracket-height -1) -0.43)  0.07 ,(+ (* bracket-height -1) -0.42)  0.10 ,(+ (* bracket-height -1) -0.42))
           (curveto  0.70  ,(+ (* bracket-height -1) -0.42)  1.10 ,(+ (* bracket-height -1) -0.60)  1.76 ,(+ (* bracket-height -1) -1.50))
           (curveto  1.82  ,(+ (* bracket-height -1) -1.58)  1.89 ,(+ (* bracket-height -1) -1.50)  1.85 ,(+ (* bracket-height -1) -1.45))
           (curveto  1.14  ,(+ (* bracket-height -1) -0.40)  0.93 ,(+ (* bracket-height -1) -0.18)  0.45 ,(* bracket-height -1))
           (closepath))))))))

repeatBarGroupAlter = 
#(define-music-function 
  (repeat-bar-type repeat-bar-height repeat-bar-translate)
  (string? number? number?)
  (cond
    ((string=? repeat-bar-type "[")  
       #{
          \once \override Staff.BarLine.stencil =
              #(lambda (grob)
                 (ly:stencil-combine-at-edge
                   (ly:bar-line::print grob)
                   X LEFT
                   (grob-interpret-markup grob 
                     #{ 
                        \markup
                        \translate #(cons 0 repeat-bar-translate)           
                        \staff-group-bracket #repeat-bar-height  
                     #})))
       #})
    ((string=? repeat-bar-type "]")  
       #{
           
           \once \override Staff.BarLine.stencil =
              #(lambda (grob)
                 (ly:stencil-combine-at-edge
                   (ly:bar-line::print grob)
                   X RIGHT
                   (grob-interpret-markup grob 
                     #{ 
                        \markup
                        \rotate #180
                        \translate #(cons 0 repeat-bar-translate)           
                        \staff-group-bracket #repeat-bar-height  
                     #})))
       #})
    (else 
        #{
           \once \override Staff.BarLine.stencil = #ly:bar-line::print
        #})))

%%% Test:
\new StaffGroup <<
  \new Staff \relative c' {
    c4 d e f
    \repeat volta 2 { 
      g a b c
      d e f g
    }
    s8
  }
  \new Staff \relative c {
    \clef F
    c4 d e f
    \repeat volta 2 { 
      \repeatBarGroupAlter #"[" #10.8 #0
      g a b c
      d e f g
      \repeatBarGroupAlter #"]" #10.8 #0
    }
    s8
  }
  \new Staff \relative c, {
    \clef F
    c4 d e f
    \repeat volta 2 { 
      g a b c
      d e f g
    }
    s8
  }
>>

\paper { tagline = ##f }

