\version "2.22.2"

\header {
  texidoc = "
It is possible to change the behavior of bar numbers in many ways.
However, it requires a certain amount of typing, using the
@code{\\override} command every time a property has to be changed.

In this example, all needed commands have been put in a Scheme music
function. Therefore, you can use it as a shortcut, at any time, to
print the bar number. If you want to print the bar number in several
bars, you can enclose the relevant section in braces @code{@{...@}} so
that the function applies to every bars in it. 

"
  doctitle = "Free BarNumber - printing the bar numbers whenever you want"
}
%% http://lsr.di.unimi.it/LSR/Item?id=431

num =
#(define-music-function (musique) (ly:music?)
    #{ 
      \override Score.BarNumber.break-visibility = ##(#f #t #t)
      $musique 
      \revert Score.BarNumber.break-visibility 
    #})
  
{
  a2 a a a
  \num a a a a 
  \num {a a a a} 
  a a a a
}



