\version "2.22.2"

\header {
  texidoc = "
This snippet lets you include a file only once, which is great for
breaking circular dependency issues. Inspired by code from 
 snippet 657
 this thread.


Compliments? Complaints? Contact Marnen Laibow-Koser, marnen AT marnen
DOT org. Enjoy!




"
  doctitle = "Include a file only once, new version"
}
%%http://lsr.di.unimi.it/LSR/Item?id=894

% includeOnce: include a file only if it hasn't already been included.
% Usage: \includeOnce "my_file.ily"
% By Marnen Laibow-Koser <marnen@marnen.org>
% Based on http://lsr.di.unimi.it/LSR/Snippet?id=657
% and 
% http://lilypond.1069038.n5.nabble.com/conditional-include-td140471.html

includeOnce =
#(define-void-function (filename) (string?)
   (if
     (not (defined? (string->symbol filename)))
     (begin
       (ly:parser-include-string 
         (string-concatenate
          (list "\\include \"" filename "\"")))
       (primitive-eval (list 'define (string->symbol filename) #t)))))

\markup { "Dummy output so that the database doesn't complain." }


