\version "2.22.2"

\header {
  texidoc = "
This snippet can be used to tune the MIDI output so that the A has an
arbitrary frequency expressed in Hertz. For example, 440 Hz is the most
common tuning, and 415 Hz is a typical baroque tuning.

"
  doctitle = "Tuning the MIDI output in Herz"
}
%% https://lilypond.community/t/diapason-midi/5559

hertzTuning =
#(define-music-function (freq) (number?)
   (let* ((freq-factor (/ freq 440))
          (tone-factor (expt 2 1/6))
          (diff (/ (log freq-factor) (log tone-factor)))
          (simple-diff (rationalize (inexact->exact diff) 1/144)))
     #{ \transposition #(ly:make-pitch 0 0 simple-diff) #}))

\score {
  \midi { }
  \layout { }
  \fixed c' {
     \hertzTuning 415
      c8 d e f g a b c'
      \hertzTuning 442
      c d e f g a b c'
  }
}
