\version "2.22.2"

\header {
  texidoc = "
The key signature indicates the tonality in which a piece is played. 
It is denoted by a set of alterations (flats or sharps) at the start of
the staff.

   Setting or changing the key signature is done with the @code{\\key}
command


@code{\\key} pitch type

Here, type should be @code{\\major} or @code{\\minor} to get
pitch-major or pitch-minor, respectively.  You may also use the
standard mode names (also called “church modes”): @code{\\ionian},
@code{\\locrian}, @code{\\aeolian}, @code{\\mixolydian},
@code{\\lydian}, @code{\\phrygian}, and @code{\\dorian}.

   
This command sets the context property @code{Staff.keySignature}. 
Non-standard key signatures can be specified by setting this property
directly.

   
Accidentals and key signatures often confuse new users, because
unaltered notes get natural signs depending on the key signature. 

"
  doctitle = "Key signatures"
}
%% http://lsr.di.unimi.it/LSR/Item?id=175

\relative c''{
  \key d \major
    a b cis d
  \key g \minor
    a bes c d
  \set Staff.printKeyCancellation = ##f
  \key d \major
    a b cis d
  \key g \minor
    a bes c d
}



