\version "2.22.2"

\header {
  texidoc = "
Supported MIDI instruments are defined in the file @code{scm/midi.scm}.
Using scheme, one can easily create a lilypond file displaying all
supported midi names automatically. The way to do this is to load the
midi.scm file and then creating a \\markup for each midi instrument
definition. This is done by a markup-list function written in Scheme.
The resulting list of markups can then be displayed using \\markuplist.

"
  doctitle = "Using Scheme to display the list of all supported midi instruments"
}
%% http://lsr.di.unimi.it/LSR/Item?id=392

%LSR upgrade by David Kastrup
%see http://lilypond.1069038.n5.nabble.com/fatal-error-define-session-used-after-session-start-with-LSR-392-td144026.html

\header { title = "Creating the list of all supported midi instruments" }

% We apply a lambda function to the list (instrument-names-alist) of instrument definitions
% That function simply creates a markup containing the name as a simple string (the first
% entry of the instrument definition is the name, thus the (car instr).
% Since we return a list of markups, we have to define that function as a markup-list command

#(define-markup-list-command (midi-instruments-markup-list layout props) ()
  (interpret-markup-list layout props
    (map (lambda (instr) (markup (car instr))) (@@ (lily) instrument-names-alist))))

% simply display the list of markups generated by the function above
\markuplist \midi-instruments-markup-list 



