\version "2.22.2"

\header {
  texidoc = "
When using a @code{\\new Chordnames @{@}} section, chords will be
included in MIDI output. When chord names are only included to ease
reading but should not sound, possibly because they are already
included in the score, this is a problem.


The sound can be changed using @code{\\set Chordnames.midiInstrument =
\"(whatever)\"}, but cannot be removed by using a non-existent
instrument: Lilypond will default to @code{acoustic grand} in such a
case.


The solution is to act at the MIDI level instead of the
@code{Chordnames}: remove the MIDI performer used for that specific
voice.


Note that the working part of the snippet is not visible in the
generated score. This is as should be, since this is only about MIDI
behaviour.



"
  doctitle = "Remove named chords from MIDI output"
}
%% http://lsr.di.unimi.it/LSR/Item?id=783

\score {
  <<
  \new ChordNames {
    \chordmode {
      d:min
    }
  }
  \new Staff {
    d'4 f'4 a'4 d''4
  }
  >>
  \layout {
  }  
  \midi {
    \context { 
      \ChordNames \remove Note_performer 
    }
  }
}



