\version "2.22.2"

\header {
  texidoc = "
Notes that are separated with a @code{\\breathe} sign are usually not
beamed in engraved music.  However, LilyPond currently ignores it by
default.

Here is a way to define a new command that includes a @code{\\noBeam}
instruction. You can even name it @qq{breathe}, if you want to replace
the existing function; however, as the example shows, there are some
limitations too, that require explicit manual beaming in some
situations.

"
  doctitle = "Preventing notes from being beamed when using \\breathe"
}
%% http://lsr.di.unimi.it/LSR/Item?id=403

% Alternative definition of \breathe that also does \noBeam

% You can as well name this function "breathe", to replace the existing one.

breathenobeam =
#(define-music-function () ()
           (make-music 'EventChord
             'origin (*location*)
             'elements (list (make-music 'BreathingEvent)
                         (make-music 'BeamForbidEvent))))
\relative c'{
  c8^"Using default \breathe" 
  d e \breathe f g f e \breathe d
  
  
  c8^"Using the new one"
   d e \breathenobeam f g f e \breathenobeam d
  
  
  c8^"limitation: \breathe and \breathenobeam are just as bad"
  [ d e] \breathenobeam f g[ f e] \breathe d 
}



