\version "2.22.2"

\header {
  texidoc = "
Draw a line or a dashed line between two fingerings. Syntax is
@code{-\\guide (dashed)#t #'(X-start-guide-line-coordinate .
Y-start-guide-line-coordinate)-finger-number}. 

"
  doctitle = "Fingering spanner"
}
%% http://lsr.di.unimi.it/LSR/Item?id=999
%% <= http://lilypond.1069038.n5.nabble.com/lilypond-fingeringOrientations-spanner-tc169349.html
%% <= http://lilypond.1069038.n5.nabble.com/Violin-fingering-td176424.html
%% <= http://lilypond.1069038.n5.nabble.com/glissando-in-fingering-notation-td159875.html

% Credits: PPS on May 2015

guide =
#(define-music-function (dashed? coord fingering) 
  (boolean? pair? ly:music?)
  "Make a line or dashed spanner, starting from the end 
   fingering and ending at the start fingering.
   One should define the ending point with x and y coordinates."
  (let ((fingering-ev (make-music 'FingeringEvent))
        (finger (ly:music-property fingering 'digit)))
    #{
      \tweak stencil
        #(lambda (grob)
          (grob-interpret-markup grob
            #{ 
              \markup 
                \concat {
            	  \line {
            	    \translate #'(0 . 0.5)
            	    \override #'(thicknes . 1.3)
            	    \with-dimensions #'(0 . 0) #'(0 . 0)
            	    #(if dashed?
            	         #{
            	           \markup
            	             \override #'(on . 0.8)
            	             \override #'(off . 0.4)
            	             \draw-dashed-line $coord 
            	         #}
            	         #{ \markup \draw-line $coord #})
            	  }
            	  \hspace #0.4
            	  #(number->string finger)
            	}
            #}))
        $fingering-ev
    #}))

%%%% Test:
sopran = {
  \set fingeringOrientations = #'(up)
  <cis'-3>16 <e'-0> <a-2> b 
  <c'-\guide ##f #'(-4 . 1)-2-1>8 
  cis' d' dis' e' f' | 
  fis' g'
  <gis'-\guide ##t #'(-39.5 . -2.5)-2-\guide ##t #'(-39.5 . -2.5)-1> 
  <a'-3-\guide ##f #'(-3.5 . -0.2)-1> bes' b'
  <c''-\guide ##t #'(-13 . -0.8)-3-\guide ##t #'(-13 . -0.8)-1> 
  <cis''-2-4>
}

bass = {
  c4\rest a16 a, ais a, b a, bis a, cis' a, d' a, | 
  dis' a, e' a, eis' a, fis' a, g' a, gis' a, a' a, g' a,
}

{
  \clef "G_8" 
  \key d \major
  << \sopran \\ \bass >> 
}


