\version "2.22.2"

\header {
  texidoc = "
This snippet demonstrates drawing colored arrows in a score, e.g. for
analysis purposes. 

These arrows have a fixed length and angle. 

If you prefer arrows that adapt to layout changes, please also have a
look at snippet 962.

"
  doctitle = "Colored arrow"
}
% http://lsr.di.unimi.it/LSR/Item?u=1&id=961
%% => http://lilypond.1069038.n5.nabble.com/scheme-problem-colored-background-layers-tc169023.html

#(define-markup-command (Arrow layout props color angle length moveX moveY) 
   (color? number? number? number? number?)
   (interpret-markup layout props
     #{
       \markup {
         \with-dimensions #'(0 . 0) #'(0 . 0)
         \translate #(cons moveX moveY)
         \rotate #angle
         \override #'(thickness . 5)    % line thickness
         \fontsize #10                  % arrow-head size
         \with-dimensions #'(0 . 0) #'(0 . 0)
         \with-color $color
         \translate #(cons 0 (- 0 length))
         \combine
         \draw-line #(cons 0 length)    % can be replaced by \draw-dashed-line or \draw-dotted-line
         \translate-scaled #'(0 . -0.5) % might have to be adjusted if line thickness is changed
         \with-color $color 
         \arrow-head #Y #DOWN ##t       % ##t - filled arrow-head, ##f - empty arrow-head
       }
     #}))

{<<
  \new Staff {R1*3} 
  \new Staff {
    e'1-\tweak layer #-1 -\markup {\Arrow #green #138 #16 #2 #2 }
    e'1-\tweak layer #-1 -\markup {\Arrow #cyan #255 #14 #-1 #2 }
    e'1-\tweak layer #2  -\markup {\Arrow #red #172 #11 #1 #2 }
    % To have the arrow behind the staff, choose a value below 0 for the layer. 
    % If you want the arrows to cover the notes, choose a value of 2 or more.
  }
>>} 


