\version "2.22.2"

\header {
  texidoc = "
This snippet shows how to print beat hints above a rhytmic staff.

"
  doctitle = "Beat hints for rhythm"
}
%% http://lsr.di.unimi.it/LSR/Item?id=901

%=> http://lilypond.1069038.n5.nabble.com/Add-beat-hints-for-rhytm-reading-tt159876.html
% by P.P.Schneider

\paper { tagline = ##f }

myBreak = {
  \break
  \once\override Score.BarNumber.X-offset = #4
  \once\override Score.Clef.space-alist.first-note = #'(minimum-fixed-space . 11.0)
}

\score {
  <<
    \new RhythmicStaff 
    \with {
      \override VerticalAxisGroup.default-staff-staff-spacing = #'()  
    }
    {
      \repeat unfold 4 { s4^1 s^2 s^3 s^4 }
      \repeat unfold 4 { s8^1 s^"+" s^2 s^"+" s^3 s^"+" s^4 s^"+" }
    }
    
    \new Staff  
    \with { 
      \consists "Pitch_squash_engraver"
      squashedPosition = #0
    }
    \relative c' { 
      \numericTimeSignature
      \clef percussion
      \set Score.proportionalNotationDuration = #(ly:make-moment 1/4)
      c4 r r2
      r4 c r2
      r2 c4 r
      r2 r4 c
      \myBreak
      \set Score.proportionalNotationDuration = #(ly:make-moment 1/8)
      r8 c r4 r2
      r4 r8 c r2
      r2 r8 c r4
      r2 r4 r8 c
    }
  >>
  \layout {
    indent = 0
    \context {
      \RhythmicStaff
      \remove "Time_signature_engraver"
      \remove "Clef_engraver"
      \override BarLine.transparent = ##t
      \override StaffSymbol.line-count = #0
    }
    \context {
      \Staff
      \override NoteHead.style = #'slash
      \override NoteHead.font-size = #-2
    }
    \context {
      \Score
      \override BarNumber.break-visibility = #end-of-line-invisible
      \override BarNumber.self-alignment-X = #LEFT
      \override BarNumber.direction = #DOWN
    }
  }
}



