\version "2.22.2"

\header {
  texidoc = "
<p>This Scheme-based snippet generates random notes. Use as</p>

<p><code>\\randomNotes <i>n</i> <i>from</i> <i>to</i>
<i>dur</i></code></p>

<p>to generate <i>n</i> random notes between pitches <i>from</i> and
<i>to</i>, with duration <i>dur</i>.</p>

"
  doctitle = "Generating random notes"
}
randomNotes =
#(define-music-function (n from to dur)
   (integer? ly:pitch? ly:pitch? ly:duration?)
   (let ((from-step (ly:pitch-steps from))
         (to-step (ly:pitch-steps to)))
     (make-sequential-music
      (map (lambda (_)
             (let* ((step (+ from-step
                             (random (- to-step from-step))))
                    (pitch (ly:make-pitch 0 step 0)))
               #{ $pitch $dur #}))
           (iota n)))))

\randomNotes 24 c' g'' 8

