\version "2.22.2"

\header {
  texidoc = "
One subtype of the 'grace synchronisation issue' is the 'grace echo'.
If a score wide collected event comes from at least one voice 'in time'
while from one or more other voices it comes 'after the grace notes
which do not exist in this/these voice(s)' the resulting grob will be
created multiple times.

For metronome marks, bar lines and time signatures a very simple
workaround is to just delete these echoed grobs. Here is an engraver
which will do this job. Bar lines and time signatures will also be
checked for equality and are only removed by this engraver if they are
identical.

Additionally, by setting a grob proptery #'keep-grace-echo = ##t you
can inhibit this grob removal to obtain a special output.


See also:

* LSR 978 (Repeat commands grace echo purger) for voltas ('\\repeat
volta' commands) * LSR 976 (Multiple simultaneous RehearsalMarks,
tunable output per score, grace synchronized) for markup commands 

"
  doctitle = "Basic Grace Echo Purger"
}
%created by: ArnoldTheresius

#(define (Basic_graceecho_purger ctx)
  (let ((last-main-moment -1)
        (current-main-moment -1)
        (barline-found #f)
        (purge-barline #f)
        (last-barline-type '())
        (current-barline-type '())
        (metronomemark-found #f)
        (purge-metronomemark #f)
        (timesignature-found #f)
        (timesignature-style-got '())
        (timesignature-style-found '())
        (timesignature-fraction-found '())
        (purge-timesignature #f)
        (grobs-to-delete '()))
    `((acknowledgers
       (bar-line-interface ; BarLines and SpanBars
        . ,(lambda (trans grob source)
            (let
             ((keep-this-echo (ly:grob-property grob 'keep-grace-echo #f))
              (grob-name (grob::name grob)))
             (if (equal? (symbol->string grob-name) "BarLine")
              (let ((barline-symbol (ly:grob-property grob 'glyph '())))
               (if (not (null? barline-symbol))
                (if (and purge-barline
                         (not keep-this-echo)
                         (equal? last-barline-type barline-symbol))
                 (begin
                  (ly:grob-set-property! grob 'glyph '())
                  (ly:context-set-property! ctx 'forbidBreak #t))
                 (begin
                  (set! barline-found #t)
                  (set! current-barline-type barline-symbol))))))))
       ) ;; bar-line-interface
       (metronome-mark-interface
        . ,(lambda (trans grob source)
            (let ((keep-this-echo (ly:grob-property grob 'keep-grace-echo #f)))
             (if (and purge-metronomemark (not keep-this-echo))
              (set! grobs-to-delete (cons grob grobs-to-delete)) ;; aka a delayed ly:grob-suicide!
              (set! metronomemark-found #t))))
       ) ;; metronome-mark-interface
       (time-signature-interface
        . ,(lambda (trans grob source)
            (let ((keep-this-echo (ly:grob-property grob 'keep-grace-echo #f)))
             (if (and purge-timesignature
                      (not keep-this-echo)
                      (equal? timesignature-style-found (ly:grob-property grob 'style))
                      (equal? timesignature-fraction-found (ly:context-property ctx 'timeSignatureFraction)))
              (set! grobs-to-delete (cons grob grobs-to-delete)) ;; aka a delayed ly:grob-suicide!
              (begin
               (set! timesignature-style-got (ly:grob-property grob 'style))
               (set! timesignature-found #t)))))
       ) ;; time-signature-interface
      ) ;; acknowledgers
      (start-translation-timestep
       . ,(lambda (trans)
           (let*
            ((now-mom (ly:context-current-moment ctx))
             (now-main-mom (ly:moment-main now-mom)))  ;; function missing in 2.14.2 !
            (set! current-main-moment now-main-mom)
            (if (equal? last-main-moment now-main-mom)
             (begin
              (if barline-found (set! purge-barline #t))
              (if metronomemark-found (set! purge-metronomemark #t))
              (if timesignature-found (begin
                (set! timesignature-fraction-found (ly:context-property ctx 'timeSignatureFraction))
                (set! timesignature-style-found timesignature-style-got)
                (set! purge-timesignature #t))))
             (begin
              (set! barline-found #f)
              (set! purge-barline #f)
              (set! metronomemark-found #f)
              (set! purge-metronomemark #f)
              (set! timesignature-found #f)
              (set! purge-timesignature #f)))))
      ) ;; start-translation-timestep
      (stop-translation-timestep
       . ,(lambda (trans)
           (for-each ly:grob-suicide! grobs-to-delete)
           (set! grobs-to-delete '())
           (set! last-barline-type current-barline-type)
           (set! last-main-moment current-main-moment))
      ) ;; stop-translation-timestep
     )))

% uncomment this to enable it by default, not only
% if it's listed in the layout block of your scores.
%{
\layout {
  \context {
    \Score
    \consists #Basic_graceecho_purger
  }
}
%}

#(define (define-grob-property symbol type? description)
  (if (not (equal? (object-property symbol 'backend-doc) #f))
      (ly:error (_ "symbol ~S redefined") symbol))

  (set-object-property! symbol 'backend-type? type?)
  (set-object-property! symbol 'backend-doc description)
  symbol)
  
#(for-each
  (lambda (x)
    (apply define-grob-property x))
    `((keep-grace-echo
      ,boolean? 
      "Do not purge this grob, it's wanted and not the result of a 'grace note 
echo' from different voices.")))

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


Music = {
  % Test the keep-grace-echo property:
  % \once \override Score.MetronomeMark.keep-grace-echo = ##t
  \tempo "slow" 4 = 54
  \partial 4
  \tag #'Grace \acciaccatura b8 c'4
  \tag #'Grace \acciaccatura b8 c'1
  \repeat volta 2 {
    \tag #'Grace \acciaccatura b8 c'1
  }
  \tag #'Grace \acciaccatura b8 c'2
  \bar "|"
  \tag #'Grace \acciaccatura b8 c'2
  % Test the keep-grace-echo property:
  % \once \override Staff.TimeSignature.keep-grace-echo = ##t
  % \once \override Staff.BarLine.keep-grace-echo = ##t
  \bar "||"
  \time 3/4
  \tag #'Grace \acciaccatura b8 c'2.
  \bar "|."
}

% Test: do not purge bar line or time signature if not equal
Appendix = {
  \time 2/4 \grace { s128 \time 3/4 } e'2.
  \time 4/4 \grace { s128 \numericTimeSignature \time 4/4 } g'1
  \bar ";" \grace { s128 \bar "S-||" s128 \bar ".." } s128 \bar "|."
}


\score {
  \new StaffGroup <<
    \new Staff {
      \Music
      %Test_only: \Appendix
    }
    \new Staff {
      \removeWithTag #'Grace \Music
      %Text_only: \Appendix
    }
  >>
  \layout {
    \context { \Score
      \consists #Basic_graceecho_purger
    }
  }
}


