\version "2.22.2"

\header {
  texidoc = "
In figured bass, the normal triads (<8 5 3> or simply <5> in LilyPond
notation) are not printed at all. However, sometimes, the bass moves,
while the upper voices in the chord should stay from the normal triad.
The usual way for this is to print an extender line without an explicit
starting figure. The simplest way to obtain this in LilyPond is to
specify an underscore instead of the figure, which is interpreted as a
space, so that only the extender line is shown. 

An alternative is to declare a bass figure as implicit, using the
implicitBassFigures property of the Staff context. The most common
setting would be \\set Staff.implicitBassFigures = #'(5), which
declares <5> an implicit figure and does not print the 5, but will
print any extenders derived from it. 

"
  doctitle = "Printing figured bass extender lines without a starting figure"
}
%% http://lsr.di.unimi.it/LSR/Item?id=607

fb = \figuremode {
  \bassFigureExtendersOn
  s4 <5> <5> <5> |
}

music = \relative c' {
  c4 c b c |
}

\new Score { <<
    % By declaring <5> to be an implicit figure,
    % the 5 is not printed, but extenders are...
    % Staff-wide setting:
    \new Staff \with { implicitBassFigures = #'(5) } <<
      \new Voice = "FiguredBass" { \fb }
      \new Voice = "Music" { \clef "bass" \music }
    >>
    % Using \set, this can be changed anywhere inside
    % the score for only a portion of the score
    \new Staff <<
      \set Staff.implicitBassFigures = #'(5)
      \new Voice = "FiguredBass" { \fb }
      \new Voice = "Music" { \clef "bass" \music }
    >>
  >>
}



