\version "2.22.2"

\header {
  texidoc = "
If you have a tempo change like a ritenuto or accelerando over a system
and a page turn, the text on the next page is in parenthesis.

An added level of difficulty is understanding the order of the text in
a broken TextSpanner in relation to the code.  Furthermore, a null
value, or string with a space (\" \") added to the 2nd text
@code{right-broken.text} overwrites its default value
@code{right.text}.  And this is especially more common and probable in
scores with fewer systems per page, e.g. orchestral scores, music for
band.  See Gould,  Behind Bars: \"Indicating continuing tempo change\",
page 185. 

"
  doctitle = "Broken TextSpan for gradual tempo changes on page turns"
}
\paper { tagline = ##f }

orderYouSeeThis = 
{
  \override TextSpanner.bound-details.left.text = "1st I see this,"
  \override TextSpanner.bound-details.right-broken.X = 94.5 % relative position, staff start is its origin
  \override TextSpanner.bound-details.right-broken.text = "2nd then this,"
  \override TextSpanner.bound-details.left-broken.text = "3rd now this:"
  \override TextSpanner.bound-details.right.text = "4th I understand this!" 
}

ritTextSpanWithBroken = 
{
  \override TextSpanner.font-shape = #'upright
  \override TextSpanner.font-series = #'bold
  \override TextSpanner.bound-details.left.text = "poco rit."
  \override TextSpanner.bound-details.right-broken.text = " " % without value, defaults right.text value
  \override TextSpanner.bound-details.left-broken.text = "(poco rit.)"
  \override TextSpanner.bound-details.right.text = "a tempo"
}

\relative c'' {
  \orderYouSeeThis
  e\startTextSpan e e e |\break
  e e e e\stopTextSpan |\break
  \bar"|."
  \revert TextSpanner.bound-details.right-broken.X
  
  \ritTextSpanWithBroken
  e\startTextSpan e e e |\break
  e e e e |
  e\stopTextSpan e e e |\break
  \bar"|."
}


