\version "2.22.2"

\header {
  texidoc = "
It is said that you cannot use numbers as part of Lilypond variable
names. They are taken as durations. Here are possibilties to do so,
anyway. Defining them in scheme or as a string. 

"
  doctitle = "Using numbers as part of Lilypond variable names"
}
%% Often I would like to use numbers in Lilypond variable names
%% for more clarity and a better overview.
%% Numbers are allowed as a part of variable names in Scheme, but not in Lilypond.
%% They would be taken as durations.

%% Here are possibilties to use numbers anyway

%% As Scheme variable: fill in your music between #{  and  #}
%% instead of backslash as prefix for reference
%% you use a dollar sign (not so bad at all ;-) )

%% With doublequotes: enclose your variablename with doublequotes and reference it
%% as usual with backslash

%% With newer versions a dotted syntax like: m.1 = ...
%% is possible, but may need some further development.

\paper { tagline = ##f }

#(define part1 #{ \relative c'' { a^\markup { This is part1 (defined as scheme variable) } e f e8 e } #} )
"part2" = \relative c'' { g_\markup { This is part2 (defined with doublequotes) } c d c8 c }

\markup 
  \column {
    "The first piece of music is named part1, the second \"part2\""
    \vspace #1
  }

\score {
  <<
    \new Staff $part1
    \new Staff \"part2"
  >>
}

\score {
 \new Staff %% you can omit \new Staff in newer Lilypond Versions
  {
    $part1
    \bar "||"
    \"part2"
  }
}


