\version "2.22.2"

\header {
  texidoc = "
To use a single percent repeat for plainchant, override the stencil for
a multi-measure rest and align the chant lyrics to a hidden note. Note
that multi-measure rests are incompatible with cadenza timing, so
normal timing should be enabled for the duration of the rest. 

"
  doctitle = "Using a percent repeat with plainchant"
}
%% http://lsr.di.unimi.it/LSR/Item?id=532

\score {
  \new Staff \relative c' {
    \cadenzaOn
    f4
    % resume normal timing so that rest can be typeset
    \cadenzaOff
    % change print function to percent repeat
    \once \override MultiMeasureRest.stencil =
      #ly:percent-repeat-interface::percent
    % correct percent repeat slash thickness
    \once \override MultiMeasureRest.thickness = #0.48
    % align percent repeat with hidden note
    \once \override MultiMeasureRest.X-offset = #3.2
    << { R1 } { \hideNotes f \unHideNotes } >>
    % hide bar line from timed section
    \bar ""
    \cadenzaOn f4 g4 a2 \bar ";"
    a4 a a g bes4 a1( g4 a) g f1 \bar "|"
  }
  \addlyrics {
    The "LORD hath said unto me: Thou" art my Son;
    this day have I be -- got -- ten thee.
  }
  \layout {
    \context {
      \Staff
      \remove "Time_signature_engraver"
    }
    \context {
      \Score
      \override BarNumber.transparent = ##t
    }
  }
}



