\version "2.22.2"

\header {
  texidoc = "
This snippet overrides the stencil for the Tab clef to include the
string names. Useful for creating tabs for beginner guitarists or for
tabs where a non-standard tuning is used. You can select the classic
tab clef or the modern tab clef.

"
  doctitle = "Tab clef with strings labeled"
}
myTabclef =
#(define-music-function () ()
   #{
      \override Staff.Clef.stencil = #ly:text-interface::print
      \override Staff.Clef.text = \markup {
        \vcenter
          \fontsize #-4
          \override #'(baseline-skip . 1.5)
          \center-column 
          \sans \bold \whiteout { E B G D A E }

        % Select classic or modern TAB; comment out the one you don't
        % want to use.

        % music glyph version
        \vcenter \musicglyph "clefs.tab"

        % modern tab version
        % \vcenter
        %   \fontsize #2 
        %   \override #'(baseline-skip . 2.4)
        %   \center-column
        %   \sans \bold { T A B }
     }
   #})


classicalGuitar =  {
  \time 4/4
  c'4 d' e' f'
}


\new StaffGroup <<
  \new Staff {
    \clef "treble_8"
    \classicalGuitar
  }
  \new TabStaff \with {
    \myTabclef
    stringTunings = #guitar-tuning
  } \classicalGuitar
>>

