\version "2.22.2"

\header {
  texidoc = "
Here is how to print text with a horizontal line drawn in the middle,
much like what you can get in HTML or CSS.

"
  doctitle = "Strikethrough text"
}
#(define-markup-command (strikethrough layout props arg)
   (markup?)
   #:category font
   #:properties ((thickness 2))
   "
@cindex strikethrough, text

Draw an horizontal line through the markup's middle.

@lilypond[verbatim,quote]
\\markup {
  The \\strikethrough Well- Tempered Clavier
}
@end lilypond"
   (let* ((th (* (ly:output-def-lookup layout 'line-thickness)
                 thickness))
          (stil (interpret-markup layout props arg))
          (xextent (ly:stencil-extent stil X))
          (yextent (ly:stencil-extent stil Y))
          (y-pos (/ (- (cdr yextent) (car yextent)) 2)))
     (ly:stencil-add
      stil
      (make-line-stencil
       th (car xextent) y-pos (cdr xextent) y-pos))))


\header { title = \markup { The \strikethrough Well- Tempered Clavier } }

\markup { by \strikethrough J.S. P.D.Q. Bach. }



