\version "2.22.2"

\header {
  texidoc = "
A snap-pizzicato (also known as @qq{Bartok pizzicato}) is a
@samp{strong pizzicato where the string is plucked vertically by
snapping and rebounds off the fingerboard of the instrument}
(Wikipedia). It is denoted by a circle with a vertical line going from
the center upwards outside the circle. While Lilypond does not have a
pre-defined command to created this markup, it is easy to create a
definition and place it directly into the lilypond file. 

"
  doctitle = "Snap-pizzicato markup (\"Bartok pizzicato\")"
}
%% http://lsr.di.unimi.it/LSR/Item?id=335
%% see also http://lsr.di.unimi.it/LSR/Item?id=827

%LSR Wilbert Berendsen and Han-Wen Nienhuys; see http://www.mail-archive.com/lilypond-user%40gnu.org/msg30785.html

#(define-markup-command (snappizz layout props) ()
  (interpret-markup layout props
    (markup #:stencil
      (ly:stencil-translate-axis
        (ly:stencil-add
          (make-circle-stencil 0.7 0.1 #f)
          (ly:make-stencil
            (list 'draw-line 0.1 0 0.1 0 1)
            '(-0.1 . 0.1) '(0.1 . 1)))
        0.7 X))))

snapPizzicato = \markup \snappizz

% now it can be used as \snappizzicato after the note/chord
% Note that a direction (-, ^ or _) is required.
\relative c' {
  c4^\snapPizzicato
  % This does NOT work:
  %<c e g>\snapPizzicato
  <c' e g>-\snapPizzicato
  <c' e g>^\snapPizzicato
  <c, e g>_\snapPizzicato
}



