\version "2.22.2"

\header {
  texidoc = "
To print only the odd bar numbers you must set the
@code{barNumberVisibility} 

* to a mode showing all bar numbers * based on a calculation of the bar
numbers to be visible.


Moreover, the @code{Score.BarNumber #'break-visibility} should be
overridden e.g. to @code{#all-visible}


This is best placed in a @code{\\layout} block to keep the music part
\"clean\".


The first bar number can also be printed by inserting @code{\\bar \"\"}
before the music.


This modulo function can also be used in a more general way! 

"
  doctitle = "Printing only odd bar numbers"
}
%% http://lsr.di.unimi.it/LSR/Item?id=712

%LSR modified/updated by P.P.Schneider on Feb 15, 2014.

\layout { 
  \context { 
    \Score 
    barNumberVisibility = #all-bar-numbers-visible 
    % this line hereunder is just to fix a v2.18.0 bug (P.P.Schneider Feb.2014)
    % (see : http://lilypond.1069038.n5.nabble.com/Bar-number-on-odd-bars-does-not-work-on-new-release-td157263.html)
    barNumberVisibility = #(lambda (n x) (= (modulo n 2) 1)) 
    % for higher version use :
    %barNumberVisibility = #(modulo-bar-number-visible 2 1) % or 2 0 to see the even bar numbers 
    \override BarNumber.break-visibility = #all-visible 
  } 
} 

\new Staff { 
  \bar ""
  \repeat unfold 8 { c'2 c' } 
}



