\version "2.22.2"

\header {
  texidoc = "
If figured bass is written using \\figuremode inside a Staff context,
then by default figures attached to rests are printed, as seen in the
first staff. To skip figures assigned to rests, one has to set the
ignoreFiguredBassRest property of the Staff to ##t.  Figures are always
printed over skips.

"
  doctitle = "Printing figured bass figures above rests in a Staff context"
}
%% http://lsr.di.unimi.it/LSR/Item?id=606

fb = \figuremode {
  s4 <6 4> <5 3> <7 _!> |
  s4 <6 4> <5 3> <7 _!> |
}

music = \relative c' {
  g4 c r e |
  g,4 c s e |
}

\new Score {
  <<
    % Figures above rests in figuremode inside a Staff context are printed:
    \new Staff <<
      \new Voice = "FiguredBass" { \fb }
      \new Voice = "Music" { \clef "bass" \music }
    >>
    % One has to set ignoreFiguredBassRest to ##t to print them:
    \new Staff \with { ignoreFiguredBassRest = ##t } <<
      \new Voice = "FiguredBass" { \fb }
      \new Voice = "Music" { \clef "bass" \music }
    >>
  >>
}



