\version "2.22.2"

\header {
  texidoc = "
In LilyPond, the longa does not have a stem in the default style.  If,
for modernized old notation, you want to force a stem to appear and
control its length,  you can do so by accessing the engraving
properties. 

"
  doctitle = "Longa with a long stem"
}
%--functions 

mylonga = #(define-music-function (pitch) (ly:pitch?)
             #{
               \tweak Stem.length 9 %exagéré pour l'exemple
               \tweak Stem.thickness 0.5
                % if style mensural ------------
               %\once \override Staff.NoteHead.stem-attachment = #'(0.8 . -0.5)
               %--------------------------------
               \once \override Staff.NoteHead.stencil = #ly:text-interface::print
               \tweak NoteHead.text  \markup {
                 % if style mensural --------
                 % \scale #'(0.5 . 1)
                 %------
                 \musicglyph "noteheads.sM1neomensural"
               }
               $pitch 2*8 #})

%--usage
{
 % \clef "mensural-c2"
 \time 4/1
 \omit Staff.TimeSignature
   \mylonga g'^"longa long stem" \mylonga c''
  \override Staff.NoteHead.style = #'baroque
  c'\longa^"normal longa"
}
