\version "2.22.2"

\header {
  texidoc = "
Usage as pseudocode: @code{@{ note [script] \\fingertrill [direction]
\"fingers\" @}}

"
  doctitle = "Fingering under bow on a trill"
}
%% See also: https://lilypond.community/t/ligature-sur-doigte-de-trille/5581

\paper { tagline = ##f }

fingertrill =
#(define-event-function (dir fingers) ((ly:dir? UP) string?)
#{
  \tweak parent-alignment-X #0
  \tweak self-alignment-X #0
  \tweak direction $dir
  -\markup \tie \finger $fingers
#})

{
  \cadenzaOn
  \acciaccatura f''8 e''4 \fingertrill "21"
  s2.
  \acciaccatura f''8 e''4\prallprall \fingertrill "2121"
  s2.
  \override Script.outside-staff-priority = #0
  \acciaccatura f''8 e''4\trill \fingertrill "3121"
}

{
  \cadenzaOn
  \acciaccatura f''8 e''4 \fingertrill #-1 "21"
  s2.
  \acciaccatura f''8 e''4_\prallprall \fingertrill #-1 "2121"
  s2.
  \override Script.outside-staff-priority = #0
  \acciaccatura f''8 e''4_\trill \fingertrill #-1 "3121"
}

