\version "2.22.2"

\header {
  texidoc = "
Sometimes it is necessary to add a simple snippet of music into a
markup function. Constructing the different notation elements manually
can be painful, because of lots of trial-and-error positioning. The
@code{\\ezscore} markup command takes the pain out of manually
constructing these music expressions in @code{\\markup} mode.


When this command is useful:



* For creating in-line notes (e.g., beamed notes, tuplets, etc.). * For
custom metronome marks. * When you need something more than a single
note.


Basically, @code{\\ezscore} is a wrapper for the @code{\\score} markup
command that puts everything on a @code{RhythmicStaff}, but
automatically removes the staff lines, clefs, and time signatures. Why
use it? Because it utilizes LilyPond's built-in layout/spacing
algorithms, so you can add any other overrides you want, which makes it
possible to do things like compressing/expanding the horizontal spacing
of notes with @code{\\newSpacingSection}.






"
  doctitle = "Easily enter music expressions in markup"
}
% see http://lists.gnu.org/archive/html/lilypond-user/2016-02/msg00692.html
% By Abraham Lee

#(define-markup-command (ezscore layout props mus) (ly:music?)
  #:properties ((size 0))
  (interpret-markup layout props
    #{
      \markup {
        \score {
          \new RhythmicStaff { $mus }
          \layout {
            \context {
              \RhythmicStaff
              \remove Clef_engraver
              \remove Time_signature_engraver
              \omit StaffSymbol
              fontSize = #size
              \override StaffSymbol.staff-space = #(magstep size)
              \override StaffSymbol.thickness = #(magstep size)
            }
            indent = 0
          }
        }
      }
    #}))

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\markup {
  Let's try something simple:
  \note {8} #UP + \note {8} #UP =
  % BEFORE USING EZNOTES...
  \combine
    \combine
      \note {4} #UP
      \translate #'(1.25 . 2.8) \beam #3 #0 #.5
    \concat {
      \hspace #3
      \note {4} #UP
    }
  . Yikes! Not so easy by hand.
}

\markup {
  Much easier:
  \note {8} #UP + \note {8} #UP =
  % AFTER USING EZNOTES...
  \ezscore ##{ { c8[ c] } #}. 
  % LET'S DO SOMETHING HARDER NOW...
  Now try constructing
  \override #'(size . -5)
  \ezscore ##{ 
    {
    \override Score.SpacingSpanner.spacing-increment = #1
    \override TupletNumber.text =
      #(tuplet-number::append-note-wrapper
         (tuplet-number::non-default-tuplet-fraction-text 12 7) (ly:make-duration 3 0))
    \tuplet 12/7 { c4. c c c } 
    } 
  #} 
  manually!
}

\paper { tagline = ##f }

