\version "2.22.2"

\header {
  texidoc = "
For screen projection and displays of all sorts it’s often preferable
to leave the background dark or black and show the content in white, in
order to obtain better contrast for difficult lighting conditions or to
be easier on the eyes. This snippet introduces two paper variables,
print-color and background-color, that will be applied to all printed
objects and to the background of the page, respectively. Any objects
whose color has been manually specified won’t have print-color applied.
NB: This implementation is incompatible with whiteout in 2.24.0, and
requires explicit overriding of whiteout-color (or the optional color
argument to the \\whiteout markup command) in recent 2.25 development
versions.

"
  doctitle = "Dark Mode Sheet Music"
}
\version "2.24.0"
% Concept and UI by Simon Albrecht
% page-post-process implementation thanks to Thomas Morley:
% https://lists.gnu.org/archive/html/lilypond-user/2025-01/msg00018.html

\paper {
  tagline = ##f
  background-color = #(x11-color "gray20")
  print-color = "ivory"

  #(define (page-post-process layout pages)
     (let ((print-color (ly:output-def-lookup $defaultpaper 'print-color #f))
           (background-color
            (ly:output-def-lookup $defaultpaper 'background-color #f)))
       (for-each
        (lambda (page)
          (let ((page-stencil (ly:prob-property page 'stencil)))
            (set! (ly:prob-property page 'stencil)
                  (if (not background-color)
                      (stencil-with-color page-stencil print-color)
                      (ly:stencil-add
                       (stencil-with-color
                        (make-filled-box-stencil
                         (ly:stencil-extent page-stencil X)
                         (ly:stencil-extent page-stencil Y))
                        background-color)
                       (stencil-with-color page-stencil print-color))))))
        pages)))
}

\header {
  title = \markup { Rendering LilyPond files white on black }
  subtitle = \markup { for screen and projector use }
}

% this sampling function is quite crude and doesn’t cover custom RBG values
% (except for "grayNN" equivalents)
#(define-markup-command (color-sample layout props clr)
   (color?)
   (let ((name (if (string? clr)
                   (string-append "\"" clr "\"")
                   (string-append "#(x11-color \"gray"
                                  (number->string (inexact->exact (* 100 (car clr))))
                                  "\")"))))
     (interpret-markup layout props
                       #{\markup \line \general-align #Y #-1 \with-color $clr {
                         \beam #5 #0 #2
                         \with-dimension-from #Y \typewriter "yl" \typewriter $name
                       }#})))

\markup \left-column {
  \strut
  \line { Any objects with unspecified colour are printed according to \typewriter print-color. }
  \vspace #.3
  \line { Here are samples of pure white along with other colours that may be }
  \line { more traditional, more pleasant or easier on the eye: }
  \typewriter {
    \color-sample "white"
    \color-sample "ivory"
    \color-sample "antiquewhite"
    \color-sample "navajowhite"
  }
  \vspace #.3
  \line { The background color may also be adjusted through the paper variable \typewriter background-color. Ideas: }
  \vspace #.3
  \combine
  \translate #'(-.7 . -10) \with-color #white \filled-box #'(0 . 50) #'(0 . 13) #.7
  \left-column {
    \color-sample "black"
    \color-sample #(x11-color "gray20")
    \color-sample "midnightblue"
    \color-sample "darkslategray"
  }
  \vspace #.3
  \line { Appendix 7 of the Notation Reference lists available colors. }
  \strut
}

{ 1 } \addlyrics { test }
