\version "2.22.2"

\header {
  texidoc = "
The following example shows how to create a dynamic marking, not
included in the default list, and assign a specific value to it so that
it affects MIDI output.


The dynamic mark @code{\\rfz} gets value @code{0.9}. 

"
  doctitle = "Creating custom dynamics in MIDI output"
}
#(define (myDynamics dynamic)
    (if (equal? dynamic "rfz")
      0.9
      (default-dynamic-absolute-volume dynamic)))

\score {
  \new Staff {
    \set Staff.midiInstrument = "cello"
    \set Score.dynamicAbsoluteVolumeFunction = #myDynamics
    \new Voice {
      \relative {
        a'4\pp b c-\rfz
      }
    }
  }
  \layout {}
  \midi {}
}

