\version "2.22.2"

\header {
  texidoc = "
Using various properties of the @code{StemTremolo} grob it is possible
to control the appearance of tremolo slashes.


* Property @code{slope} sets the slope for tremolo slashes.

* Property @code{shape} determines whether tremolo slashes look like
rectangles (value @code{rectangle}) or like very small beams (value
@code{beam-like}).

* Property @code{style} sets both the slope and the shape depending on
whether the note has flags, beams, or only a plain stem.  This is in
contrast to the previous two properties, which change the slope and
shape unconditionally.  There are two styles defined.


  
* @code{default}: slashes for down-stem flags are longer and more
sloped than slashes for up-stem flags; slashes on beamed notes have a
rectangular shape and are parallel to the beam. * @code{constant}: all
slashes are beam-like and have the same slope except for down-stem
flags.





"
  doctitle = "Controlling the appearance of tremolo slashes"
}
music = {
  a''4:32 a':
  e''8: \noBeam e':
  a'':[ a':]
  f':[ g':]
  d':[ d':]
}

\new Staff {
  <>^\markup "default"
  \music
}

\new Staff {
  <>^\markup \typewriter "style = #'constant"
  \override StemTremolo.style = #'constant
  \music
}

\new Staff {
  <>^\markup \typewriter "shape = #'rectangle"
  \override StemTremolo.shape = #'rectangle
  \music
}

\new Staff {
  <>^\markup \typewriter "shape = #'beam-like"
  \override StemTremolo.shape = #'beam-like
  \music
}

\new Staff {
  <>^\markup \typewriter "slope = -0.2"
  \override StemTremolo.slope = -0.2
  \music
}

\paper {
  indent = 0
  tagline = ##f
}

