\version "2.22.2"

\header {
  texidoc = "
It is possible to color note heads depending on their pitch and/or
their names: the function used in this example even makes it possible
to distinguish enharmonics.

This is an alternate version of the original snippet found here:
http://lsr.di.unimi.it/LSR/Item?id=572 This version achieves the same
result by using different code that some may find easier to understand.
(It uses @code{case} rather than an association list to assign the
colors.) 

"
  doctitle = "Coloring notes depending on their pitch (alternate version)"
}
%%http://lsr.di.unimi.it/LSR/Item?id=897

#(define (color-notehead grob)
   (let* ((pch (ly:event-property (event-cause grob) 'pitch))
          (nnm (ly:pitch-notename pch))
          (alt (ly:pitch-alteration pch)))
          (case nnm
                 ((0) (case alt
                        ((-1) red) ;; Cbb
                        ((-1/2) red) ;; Cb
                        ((0) red) ;; C
                        ((1/2) red) ;; C#
                        ((1) red) ;; C##
                        (else black)))
                 ((1) (case alt
                        ((-1) (x11-color 'orange)) ;; Dbb
                        ((-1/2) (x11-color 'orange)) ;; Db
                        ((0) (x11-color 'orange)) ;; D
                        ((1/2) (x11-color 'orange)) ;; D#
                        ((1) (x11-color 'orange)) ;; D##
                        (else black)))
                 ((2) (case alt
                        ((-1) yellow) ;; Ebb
                        ((-1/2) yellow) ;; Eb
                        ((0) yellow) ;; E
                        ((1/2) yellow) ;; E#
                        ((1) yellow) ;; E##
                        (else black)))
                 ((3) (case alt
                        ((-1) green) ;; Fbb
                        ((-1/2) green) ;; Fb
                        ((0) green) ;; F
                        ((1/2) green) ;; F#
                        ((1) green) ;; F##
                        (else black)))
                 ((4) (case alt
                        ((-1) blue) ;; Gbb
                        ((-1/2) blue) ;; Gb
                        ((0) blue) ;; G
                        ((1/2) blue) ;; G#
                        ((1) blue) ;; G##
                        (else blue)))
                 ((5) (case alt
                        ((-1) (x11-color 'purple)) ;; Abb
                        ((-1/2) (x11-color 'purple)) ;; Ab
                        ((0) (x11-color 'purple)) ;; A
                        ((1/2) (x11-color 'purple)) ;; A#
                        ((1) (x11-color 'purple)) ;; A##
                        (else black)))
                 ((6) (case alt
                        ((-1) (x11-color 'brown)) ;; Bbb
                        ((-1/2) (x11-color 'brown)) ;; Bb
                        ((0) (x11-color 'brown)) ;; B
                        ((1/2) (x11-color 'brown)) ;; B#
                        ((1) (x11-color 'brown)) ;; B##
                        (else black)))
                 (else black))))

\score {
  \new Staff \relative c' {
    \override NoteHead.color = #color-notehead
    c8 b d dis ees f g aes
  }
}


