\version "2.22.2"

\header {
  texidoc = "
If you want to adjust the shape of a slur, one way is to specify a new
list of control-points.  This function offers a different approach by
allowing you to adjust existing control-points. This is done by
entering a list of offsets (in staff spaces) to the default
coordinates: @code{\\shapeSlur #'(x1 y1 x2 y2 x3 y3 x4 y4)}  

Setting a value to 0 leaves the default coordinate unchanged, so it is
easy to maintain a slur's attachment-points while changing its
interior. 

"
  doctitle = "Altering the shape of a default slur with a list of offsets"
}
%% http://lsr.di.unimi.it/LSR/Item?id=639
%% see also http://lsr.di.unimi.it/LSR/Item?id=777

% LSR Thanks to Neil Puttock for his help!

shapeSlur =
  #(define-music-function (offsets) (list?)
    #{
       \once \override Slur.control-points = #(alter-curve offsets)
    #})

#(define ((alter-curve offsets) grob)
   (let ((coords (ly:slur::calc-control-points grob)))

     (define (add-offsets coords offsets)
       (if (null? coords)
       '()
       (cons
	 (cons (+ (caar coords) (car offsets))
	       (+ (cdar coords) (cadr offsets)))
	 (add-offsets (cdr coords) (cddr offsets)))))

     (add-offsets coords offsets)))

\relative c'' {
  d4(^"default" d' b g f8 e d e c2)
  \bar "||"
  \shapeSlur #'(0 -2.5 -1 3.5 0 0 0 -2.5)
  d4(^"(0 -2.5 -1 3.5 0 0 0 -2.5)" d' b g f8 e d e c2)
}



