\version "2.22.2"

\header {
  texidoc = "
To add an extra staff after the start of a piece, you can choose
between having brackets or braces when you go over a new line:
 => Use @code{PianoStaff} instead of @code{StaffGroup} or
@code{ChoirStaff} in the code.


You may wish to remove the clef and not only the key:
 => See both @code{\\override}s in the code.


You may wish to remove also the little part of staff at the beginning
of the extra staff:
 => Use @code{#'stencil = ##f} instead of @code{#'transparent = ##t} for
both @code{\\override}s. If you want to keep the little beginning of
staff, keep at least one @code{#'transparent = ##t}. 

"
  doctitle = "Adding an extra staff (2)"
}
%% http://lsr.di.unimi.it/LSR/Item?id=707

% snippet starts here:

\markup { Example 1 }

\score {
  \new StaffGroup \relative c'' {
    c1 | c | c^"extra staff with staff beginning"
    <<
      {
        c1 | c | \break
        c1^"new system with brackets" | c
      }
      \new Staff {
        \once \override Staff.TimeSignature.transparent = ##t
        \once \override Staff.Clef.transparent = ##t
        e1 | e | e | e
      }
    >>
    c1 | c | c | c
  }
}

\markup { Example 2 }
\score {
  \new PianoStaff \relative c'' {
    c1 | c | c^"clean beginning of extra staff"
    <<
      {
        c1 | c | \break
        c1^"new system with braces" | c
      }
      \new Staff {
        \once \override Staff.TimeSignature.stencil = ##f
        \once \override Staff.Clef.stencil = ##f
        e1 e e e
      }
    >>
    c1 | c | c | c
  }
}

\paper { tagline = ##f }

